package com.wissamfawaz;

public class ArrayBasedStack implements Stack {
    private Object[] array;
    private int top;

    public ArrayBasedStack(int capacity) {
        array = new Object[capacity];
        top = -1;
    }

    @Override
    public int size() {
        return top + 1;
    }

    @Override
    public boolean isEmpty() {
        return size() == 0;
    }

    @Override
    public void push(Object element) throws StackException {
        if (size() == array.length) {
            throw new StackException("Stack is full!");
        }
        top++;
        array[top] = element;
    }

    @Override
    public Object pop() throws StackException {
        if(isEmpty()) {
            throw new StackException("Stack is empty!");
        }

        Object toReturn = array[top];
        array[top] = null;
        top--;
        return toReturn;
    } 

    @Override
    public Object top() throws StackException {
        if(isEmpty()) {
            throw new StackException("Stack is empty!");
        }

        return array[top];
    }

}
